@extends('layouts.user')

@section('content')
<div class="container mt-5">
    <div class="card p-4">
        <h4 class="mb-4">User to User Transfer</h4>

        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @elseif(session('error'))
            <div class="alert alert-danger">{{ session('error') }}</div>
        @endif

        <form action="{{ route('user.transfer.store') }}" method="POST">
            @csrf

            <div class="form-group mb-3">
                <label for="recipient">Recipient Username</label>
                <input type="text" name="recipient" class="form-control" required placeholder="Enter recipient username">
            </div>

            <div class="form-group mb-3">
                <label for="amount">Amount</label>
                <input type="number" step="0.01" name="amount" class="form-control" required placeholder="Enter amount to transfer">
            </div>

            <div class="form-group mb-3">
                <label for="fund_password">Fund Password</label>
                <input type="password" name="fund_password" class="form-control" required placeholder="Enter your fund password">
            </div>

            <button type="submit" class="btn btn-primary">Transfer Now</button>
        </form>
    </div>
</div>
@endsection
